<?php
// Inclui funções e inicia a sessão
include "includes/functions.php";

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Verifica se o usuário está logado
$log_check = $db->select("users", "*", "id = :id", "", [":id" => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]["username"] : NULL;
if (!empty($loggedinuser) && isset($_SESSION["name"]) && $_SESSION["name"] === $loggedinuser) {
    header("Location: dns.php");
    exit;
}

// Insere o usuário admin se não existir
$data = ["id" => "1", "username" => "admin", "password" => "admin"];
$db->insertIfEmpty("users", $data);

// Processa o login
if (isset($_POST["login"])) {
    $username = $_POST["username"];
    $userData = $db->select("users", "*", "username = :username", "", [":username" => $username]);
    if ($userData) {
        $storedPassword = $userData[0]["password"];
        if ($_POST["password"] === $storedPassword) {
            session_regenerate_id();
            $_SESSION["loggedin"] = true;
            $_SESSION["name"] = $_POST["username"];
            header($_POST["username"] == "admin" ? "Location: user.php" : "Location: dns.php");
        } else {
            header("Location: ./api/index.php");
        }
    } else {
        header("Location: ./api/index.php");
    }
    $db->close();
}

// HTML da página
echo <<<HTML
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="MAXLOJA">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <link rel="stylesheet" href="./css/css.css">
    <title>maxloja APlicativos</title>
    <style>
        body {
            background-color: #181828;
            background-image: url("./img/seu_fundo_animado.gif"); /* Altere para o caminho do fundo desejado */
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            color: #fff;
        }
        #js-particles {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
        }
        .container-custom {
            background-color: rgba(0, 0, 0, 0.93);
            padding: 20px;
            border-radius: 10px;
            width: 100%;
            max-width: 400px;
            margin: auto;
            position: relative;
            z-index: 1;
        }
        input.form-control {
            border-radius: 25px; /* Arredonda os campos de entrada */
        }
        .btn {
            border-radius: 25px; /* Arredonda os botões */
        }
        .btn-orange {
            background-color: #FFA500; /* Laranja */
            border: none;
            color: #fff;
        }
        .btn-orange:hover {
            background-color: #FF8C00; /* Laranja mais escuro ao passar o mouse */
        }
        .btn-green-neon {
            background-color: #39FF14; /* Verde Neon */
            border: none;
            color: #000;
        }
        .btn-green-neon:hover {
            background-color: #32CD32; /* Verde neon mais escuro ao passar o mouse */
        }
        .description {
            color: #fff;
            font-weight: bold;
            text-align: center;
            margin-top: 15px;
        }
        .description-link {
            color: blue;
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div id="js-particles"></div>
    <br><br>
    <div class="container-custom">
        <div class="text-center">
            <img class="w-75 p-3" src="./img/logo.png" alt="Logo">
        </div>
        <form method="post">
            <div class="form-group">
                <input type="text" class="form-control form-control-lg" placeholder="Username" name="username" required autofocus>
            </div>
            <div class="form-group">
                <input type="password" class="form-control form-control-lg" placeholder="Password" name="password" required>
            </div>
            <input type="submit" class="btn btn-orange btn-lg btn-block" value="Log In" name="login">
            <br>
            <a class="btn btn-green-neon btn-lg btn-block" href="https://wa.me/message/5585986460310" download>Suporte</a>
            
        </form>
    </div>
    
    
    <br><br>
    <script src="https://code.jquery.com/jquery-3.3.1.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49"
    crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" 
    crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script>
        particlesJS('js-particles', {
            particles: {
                number: { value: 100 },
                color: { value: "#ffffff" },
                shape: { type: "circle" },
                opacity: { value: 0.5 },
                size: { value: 3 },
                move: { enable: true, speed: 2 }
            }
        });
    </script>
</body>
</html>
HTML;
?>
