<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Filmes Populares com Backdrops e Logos</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            position: relative;
            height: 100vh;
            background-color: #222;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        #backdrop {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .movie-container {
            position: relative;
            z-index: 1;
            max-width: 800px;
            padding: 20px;
            background-color: rgba(0, 0, 0, 0.5);
            border-radius: 5px;
            color: #fff;
            display: flex;
            flex-direction: row;
            align-items: center;
        }
        .logo {
            max-width: 150px;
            margin-right: 20px;
        }
        .movie-info {
            flex: 1;
            font-size: 18px;
        }
        .poster {
            max-width: 200px;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    
    <img id="backdrop" alt="Backdrop">
    <div class="movie-container">
        <img id="logo" class="logo" alt="Logo">
        <div class="movie-info" id="movie-info"></div>
        <img id="poster" class="poster" alt="Poster">
    </div>

    <script>
        const apiKey = "6b8e3eaa1a03ebb45642e9531d8a76d2"; // Substitua pela sua chave da API TMDB
        let currentIndex = 0;
        let movieIds = [];

        async function fetchPopularMovieIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=pt-BR`);
                if (!response.ok) throw new Error('Erro ao buscar filmes populares');
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
            } catch (error) {
                console.error('Erro ao buscar filmes populares:', error);
            }
        }

        async function fetchMovieData(movieId, type = 'images') {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/${type}?api_key=${apiKey}`);
                if (!response.ok) throw new Error(`Erro ao buscar ${type} do filme`);
                return await response.json();
            } catch (error) {
                console.error(`Erro ao buscar ${type} do filme:`, error);
            }
        }

        async function fetchMovieInfo(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&language=pt-BR`);
                if (!response.ok) throw new Error('Erro ao buscar informações do filme');
                const data = await response.json();
                return {
                    title: data.title,
                    releaseDate: data.release_date,
                    overview: data.overview
                };
            } catch (error) {
                console.error('Erro ao buscar informações do filme:', error);
            }
        }

        async function updateContent() {
            if (!movieIds.length) return console.error('Nenhum ID de filme disponível.');

            const movieId = movieIds[currentIndex];
            try {
                // Atualizar Backdrop
                const backdropData = await fetchMovieData(movieId);
                if (backdropData?.backdrops?.length) {
                    document.getElementById('backdrop').src = `https://image.tmdb.org/t/p/original${backdropData.backdrops[0].file_path}`;
                }

                // Atualizar Logo
                const logoData = await fetchMovieData(movieId, 'images');
                const englishLogo = logoData?.logos?.find(logo => logo.iso_639_1 === 'en');
                if (englishLogo) {
                    document.getElementById('logo').src = `https://image.tmdb.org/t/p/w500${englishLogo.file_path}`;
                }

                // Atualizar Pôster
                if (backdropData?.posters?.length) {
                    document.getElementById('poster').src = `https://image.tmdb.org/t/p/w500${backdropData.posters[0].file_path}`;
                }

                // Atualizar Informações
                const movieInfo = await fetchMovieInfo(movieId);
                if (movieInfo) {
                    document.getElementById('movie-info').innerHTML = `
                        <strong>${movieInfo.title}</strong> (${movieInfo.releaseDate?.substring(0, 4)})<br>
                        ${movieInfo.overview}
                    `;
                }

                // Atualizar índice
                currentIndex = (currentIndex + 1) % movieIds.length;
            } catch (error) {
                console.error('Erro ao atualizar conteúdo:', error);
            }
        }

        fetchPopularMovieIds().then(() => {
            setInterval(updateContent, 6000); // Atualiza a cada 6 segundos
            updateContent(); // Atualização inicial
        });
    </script>
</body>
</html