<?php
// Salvar log (opcional, para teste)
file_put_contents('webhook_log.txt', date('Y-m-d H:i:s') . ' - ' . file_get_contents('php://input') . "\n", FILE_APPEND);

// Conexão com banco
$db_host = 'localhost';
$db_name = 'u403845897_gerenciarlcs';
$db_user = 'u403845897_gerenciarlcs';
$db_pass = 'jPS?sdNB$3';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
} catch (PDOException $e) {
    error_log("Erro na conexão: " . $e->getMessage());
    http_response_code(500);
    exit("Erro na conexão.");
}

// Receber dados do Mercado Pago
$input = json_decode(file_get_contents("php://input"), true);

// Verificar se é notificação de pagamento
if (isset($input['type']) && $input['type'] === 'payment') {
    $idPagamento = $input['data']['id'];

    // Buscar dados do pagamento
    $access_token = 'APP_USR-1017418177003611-081623-8a8dd68e71e7fc1aad1bd29e91325b39-1950953558';
    $ch = curl_init("https://api.mercadopago.com/v1/payments/$idPagamento");
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $access_token"
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $resposta = curl_exec($ch);

    // Verificar se a requisição foi bem sucedida
    if ($resposta === false) {
        error_log("Erro na requisição à API: " . curl_error($ch));  // Registrar o erro no log de erros
        http_response_code(500);
        exit("Erro ao processar o pagamento.");
    }

    curl_close($ch);

    // Decodificar a resposta
    $pagamento = json_decode($resposta, true);

    // Verificar se o pagamento foi aprovado
    if (isset($pagamento['status']) && $pagamento['status'] === 'approved') {
        $referencia = $pagamento['external_reference']; // Esse é o domínio do cliente

        // Ativar cliente no banco
        $stmt = $pdo->prepare("UPDATE clientes SET status = 'ativo', vencimento = DATE_ADD(NOW(), INTERVAL 30 DAY) WHERE dominio = ?");
        $stmt->execute([$referencia]);
    } else {
        // Log de erro caso o pagamento não tenha sido aprovado
        error_log("Pagamento não aprovado. ID: $idPagamento");
        http_response_code(400); // Notificação inválida
        exit("Pagamento não aprovado.");
    }
}

http_response_code(200); // Resposta OK
echo "OK";
?>
