<?php
session_start();
if (!isset($_SESSION['usuario_id'])) {
    header('Location: login.php');
    exit;
}

include('includes/db.php');

// Verificar se o ID do cliente foi passado
$id = $_GET['id'] ?? null;
if (!$id) {
    echo "ID inválido!";
    exit;
}

// Buscar os dados do cliente antes de renovar
$stmt = $pdo->prepare("SELECT * FROM clientes WHERE id = ?");
$stmt->execute([$id]);
$cliente = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$cliente) {
    echo "Cliente não encontrado!";
    exit;
}

// Atualizar o vencimento +30 dias
$stmtUpdate = $pdo->prepare("UPDATE clientes SET vencimento = DATE_ADD(vencimento, INTERVAL 30 DAY), status = 'ativo' WHERE id = ?");
$stmtUpdate->execute([$id]);

// Preparar os dados para enviar via GET
$nome = urlencode($cliente['nome']);
$dominio = urlencode($cliente['dominio']);
$tipo = urlencode($cliente['tipo']);
$preco = urlencode($cliente['preco']);
$whatsapp = urlencode($cliente['whatsapp']);
$vencimento = date('Y-m-d', strtotime($cliente['vencimento'] . ' +30 days'));

// Redirecionar para a página com o modal
header("Location: clientes.php?renovado=1&nome=$nome&dominio=$dominio&tipo=$tipo&preco=$preco&whatsapp=$whatsapp&vencimento=$vencimento");
exit;
?>
