<?php
include('includes/autenticar.php');
include('includes/db.php');

$id = $_GET['id'] ?? null;
if (!$id) {
    echo "ID inválido!";
    exit;
}

// Buscar dados atuais do cliente
$stmt = $pdo->prepare("SELECT * FROM clientes WHERE id = ?");
$stmt->execute([$id]);
$cliente = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$cliente) {
    echo "Cliente não encontrado.";
    exit;
}

// Se for post, atualizar os dados
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = $_POST['nome'];
    $dominio = $_POST['dominio'];
    $preco = $_POST['preco'];
    $tipo = $_POST['tipo'];
    $vencimento = $_POST['vencimento'];
    $whatsapp = $_POST['whatsapp'];

    // Atualiza os dados principais
    $update = $pdo->prepare("UPDATE clientes SET nome = ?, dominio = ?, preco = ?, tipo = ?, vencimento = ?, whatsapp = ? WHERE id = ?");
    $update->execute([$nome, $dominio, $preco, $tipo, $vencimento, $whatsapp, $id]);

    // Recalcular o status com base na nova data de vencimento
    $hoje = date('Y-m-d');
    $novoStatus = ($vencimento < $hoje) ? 'vencido' : 'ativo';

    // Atualiza o status (somente se não estiver bloqueado)
    if ($cliente['status'] !== 'bloqueado') {
        $updateStatus = $pdo->prepare("UPDATE clientes SET status = ? WHERE id = ?");
        $updateStatus->execute([$novoStatus, $id]);
    }

    echo "✅ Cliente atualizado com sucesso.";
    echo "<br><a href='clientes.php'>Voltar</a>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Editar Cliente</title>
    <style>
        body {
            background: #111;
            color: #fff;
            font-family: sans-serif;
            padding: 30px;
        }
        h2 {
            color: #00cc66;
            margin-bottom: 20px;
        }
        .form-container {
            background: #222;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
        }
        input, select {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            background: #333;
            border: none;
            color: #fff;
            border-radius: 5px;
        }
        button {
            padding: 10px 20px;
            background: #00cc66;
            border: none;
            color: #fff;
            cursor: pointer;
        }
    </style>
</head>
<body>

<h2>✏️ Editar Cliente</h2>

<form method="POST">
    <input type="text" name="nome" value="<?= htmlspecialchars($cliente['nome']) ?>" required>
    <input type="text" name="dominio" value="<?= htmlspecialchars($cliente['dominio']) ?>" required>
    <input type="number" name="preco" step="0.01" value="<?= htmlspecialchars($cliente['preco']) ?>" placeholder="Preço (R$)" required>
    <input type="text" name="whatsapp" value="<?= htmlspecialchars($cliente['whatsapp']) ?>" placeholder="WhatsApp" required>
    <select name="tipo" required>
        <option value="App" <?= $cliente['tipo'] === 'App' ? 'selected' : '' ?>>App</option>
        <option value="Loja" <?= $cliente['tipo'] === 'Loja' ? 'selected' : '' ?>>Loja</option>
        <option value="Site" <?= $cliente['tipo'] === 'Site' ? 'selected' : '' ?>>Site</option>
    </select>
    <input type="date" name="vencimento" value="<?= $cliente['vencimento'] ?>" required>
    <button type="submit">Salvar Alterações</button>
</form>

</body>
</html>
