<?php
session_start();
$clienteExcluido = isset($_GET['excluido']) && $_GET['excluido'] == 1;
$clienteEditado = isset($_GET['editado']) && $_GET['editado'] == 1;
include('includes/db.php');

// Verificar se o usuário está logado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: login.php');  // Redireciona para login se não estiver logado
    exit;
}

$tituloSistema = $pdo->query("SELECT titulo FROM configuracoes LIMIT 1")->fetchColumn();
$logo = $pdo->query("SELECT logo FROM configuracoes LIMIT 1")->fetchColumn();

$hoje = date('Y-m-d');
$clientesVencidos = $pdo->query("SELECT * FROM clientes WHERE vencimento < '$hoje' AND status != 'bloqueado'")->fetchAll(PDO::FETCH_ASSOC);
foreach ($clientesVencidos as $cli) {
    $stmt = $pdo->prepare("UPDATE clientes SET status = 'vencido' WHERE id = ?");
    $stmt->execute([$cli['id']]);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!empty($_POST['edit_id'])) {
        $stmt = $pdo->prepare("UPDATE clientes SET nome=?, dominio=?, tipo=?, vencimento=?, preco=?, codigo_verificacao=?, whatsapp=? WHERE id=?");
        $stmt->execute([
            $_POST['nome'], $_POST['dominio'], $_POST['tipo'], $_POST['vencimento'],
            $_POST['preco'], $_POST['codigo_verificacao'], $_POST['whatsapp'], $_POST['edit_id']
        ]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO clientes (nome, dominio, tipo, vencimento, preco, codigo_verificacao, whatsapp) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $_POST['nome'], $_POST['dominio'], $_POST['tipo'], $_POST['vencimento'],
            $_POST['preco'], $_POST['codigo_verificacao'], $_POST['whatsapp']
        ]);
    }
    header("Location: clientes.php?editado=1");
    exit;
}

$clientes = $pdo->query("SELECT * FROM clientes ORDER BY vencimento ASC")->fetchAll(PDO::FETCH_ASSOC);

$totalAtivos = $totalVencidos = $totalBloqueados = 0;
foreach ($clientes as $c) {
    if ($c['status'] === 'ativo') $totalAtivos++;
    elseif ($c['status'] === 'vencido') $totalVencidos++;
    elseif ($c['status'] === 'bloqueado') $totalBloqueados++;
}

$totalClientes = count($clientes);
?>
<!DOCTYPE html>
<html lang="pt-br" class="dark">
<head>
  <meta charset="UTF-8">
  <title>Clientes - <?= $tituloSistema ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <script src="https://cdn.tailwindcss.com"></script>
  <script>tailwind.config = { darkMode: 'class' }</script>
  <script src="https://unpkg.com/@phosphor-icons/web"></script>
  <style>
    @media (max-width: 768px) {
      body { overflow-x: hidden; }
      .tabela-clientes-wrapper { overflow-x: auto; -webkit-overflow-scrolling: touch; }
      table { min-width: 800px; }
    }
  </style>
</head>
<body class="bg-gray-100 dark:bg-gray-900 text-gray-800 dark:text-gray-100">
<div class="flex min-h-screen">
  <div id="sidebar" class="w-64 bg-white dark:bg-gray-800 shadow-md transition-transform duration-300 -translate-x-full md:translate-x-0 md:block absolute md:relative z-50">
    <aside class="w-full h-full">
      <div class="p-6 text-2xl font-bold text-blue-600 dark:text-white"><?= $tituloSistema ?></div>
      <nav class="space-y-2 px-4 text-sm">
        <a href="dashboard.php" class="flex items-center gap-3 p-2 rounded-md hover:bg-gray-100 dark:hover:bg-gray-700"><i class="ph ph-gauge"></i> Dashboard</a>
        <a href="#" class="flex items-center gap-3 p-2 rounded-md bg-blue-100 dark:bg-blue-800 text-blue-600 dark:text-white font-medium"><i class="ph ph-users"></i> Clientes</a>
        <a href="configuracoes.php" class="flex items-center gap-3 p-2 rounded-md hover:bg-gray-100 dark:hover:bg-gray-700"><i class="ph ph-gear"></i> Configurações</a>
        <a href="logout.php" class="flex items-center gap-3 p-2 rounded-md hover:bg-gray-100 dark:hover:bg-gray-700 text-red-600 dark:text-red-400 font-medium">
  <i class="ph ph-sign-out"></i> Sair
</a>
      </nav>
    </aside>
  </div>

  <main class="flex-1 p-4 md:p-6 bg-gray-100 dark:bg-gray-900 w-full">
    <div class="flex justify-between items-center mb-6">
      <h1 class="text-xl font-semibold">Clientes</h1>
      <div class="flex items-center gap-4">
        <button onclick="toggleSidebar()" class="w-10 h-10 rounded-md bg-blue-600 text-white flex items-center justify-center md:hidden"><i class="ph ph-list text-xl"></i></button>
        <button id="toggleTheme" class="w-10 h-10 rounded-full bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 flex items-center justify-center"><i class="ph ph-sun text-yellow-500 dark:text-yellow-300 text-xl"></i></button>
        <img src="uploads/<?= $logo ?>" class="w-9 h-9 rounded-full object-cover" alt="Logo">
      </div>
    </div>
    <!-- Resumo -->
    <div class="grid grid-cols-2 sm:grid-cols-4 gap-4 text-sm mb-6">
      <div class="bg-gray-200 dark:bg-gray-700 p-3 rounded text-center">
        <p class="font-semibold text-gray-700 dark:text-gray-300">Total</p>
        <p class="text-xl font-bold text-gray-800 dark:text-white"><?= $totalClientes ?></p>
      </div>
      <div class="bg-green-100 dark:bg-green-800 p-3 rounded text-center">
        <p class="font-semibold text-green-800 dark:text-green-200">Ativos</p>
        <p class="text-xl font-bold text-green-900 dark:text-white"><?= $totalAtivos ?></p>
      </div>
      <div class="bg-yellow-100 dark:bg-yellow-800 p-3 rounded text-center">
        <p class="font-semibold text-yellow-800 dark:text-yellow-200">Vencidos</p>
        <p class="text-xl font-bold text-yellow-900 dark:text-white"><?= $totalVencidos ?></p>
      </div>
      <div class="bg-red-100 dark:bg-red-800 p-3 rounded text-center">
        <p class="font-semibold text-red-800 dark:text-red-200">Bloqueados</p>
        <p class="text-xl font-bold text-red-900 dark:text-white"><?= $totalBloqueados ?></p>
      </div>
    </div>

    <!-- Busca + Novo -->
    <div class="flex flex-col sm:flex-row justify-between items-center gap-4 mb-4">
      <input type="text" id="buscaCliente" placeholder="Buscar por nome, domínio ou WhatsApp..." class="w-full sm:w-96 px-4 py-2 rounded border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-sm">
      <button onclick="document.getElementById('clienteModal').classList.remove('hidden')" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded shadow flex items-center gap-2"><i class="ph ph-plus-circle"></i> Novo Cliente</button>
    </div>

    <!-- Tabela com rolagem no mobile -->
    <div class="tabela-clientes-wrapper overflow-auto rounded-lg bg-white dark:bg-gray-800 p-4 shadow">
      <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
        <thead class="bg-blue-900 text-white text-xs font-semibold uppercase">
          <tr>
            <th class="px-4 py-3">Nome</th>
            <th class="px-4 py-3">Domínio</th>
            <th class="px-4 py-3">Tipo</th>
            <th class="px-4 py-3">Preço</th>
            <th class="px-4 py-3">WhatsApp</th>
            <th class="px-4 py-3">Vencimento</th>
            <th class="px-4 py-3">Status</th>
            <th class="px-4 py-3">Ações</th>
          </tr>
        </thead>
        <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
          <?php foreach ($clientes as $cliente): 
              $vencido = ($cliente['vencimento'] < $hoje);
              $status = $cliente['status'];

              if ($status === 'vencido') {
                  $statusTexto = 'Vencido';
                  $statusClasse = 'bg-yellow-100 text-yellow-800';
              } elseif ($status === 'bloqueado') {
                  $statusTexto = 'Bloqueado';
                  $statusClasse = 'bg-red-100 text-red-800';
              } elseif ($status === 'ativo') {
                  $statusTexto = 'Ativo';
                  $statusClasse = 'bg-green-100 text-green-800';
              } else {
                  $statusTexto = ucfirst($status);
                  $statusClasse = 'bg-gray-100 text-gray-800';
              }
          ?>
          <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
            <td class="px-4 py-3 font-medium"><?= htmlspecialchars($cliente['nome']) ?></td>
            <td class="px-4 py-3"><?= htmlspecialchars($cliente['dominio']) ?></td>
            <td class="px-4 py-3"><?= $cliente['tipo'] ?></td>
            <td class="px-4 py-3">R$ <?= number_format($cliente['preco'], 2, ',', '.') ?></td>
            <td class="px-4 py-3"><?= htmlspecialchars($cliente['whatsapp']) ?></td>
            <td class="px-4 py-3 <?= $vencido ? 'text-red-500 font-semibold' : '' ?>"><?= date('d/m/Y', strtotime($cliente['vencimento'])) ?></td>
            <td class="px-4 py-3"><span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium <?= $statusClasse ?>"><?= $statusTexto ?></span></td>
            <td class="px-4 py-3 flex gap-2">
              <?php if ($status === 'ativo'): ?>
                <a href="bloquear_cliente.php?id=<?= $cliente['id'] ?>" class="text-red-600" title="Bloquear"><i class="ph ph-lock"></i></a>
              <?php else: ?>
                <a href="desbloquear_cliente.php?id=<?= $cliente['id'] ?>" class="text-green-600" title="Desbloquear"><i class="ph ph-lock-open"></i></a>
              <?php endif; ?>
              <a href="renovar_cliente.php?id=<?= $cliente['id'] ?>" class="text-gray-600" title="Renovar"><i class="ph ph-arrow-clockwise"></i></a>
              <a href="#" onclick="editarCliente(<?= htmlspecialchars(json_encode($cliente), ENT_QUOTES, 'UTF-8') ?>)" class="text-yellow-600" title="Editar"><i class="ph ph-pencil"></i></a>
              <a href="excluir_cliente.php?id=<?= $cliente['id'] ?>&redirect=clientes.php?excluido=1" onclick="return confirm('Excluir cliente?')" class="text-red-600" title="Excluir"><i class="ph ph-trash"></i></a>
              <a href="#" onclick="copiarInfoCliente(<?= htmlspecialchars(json_encode($cliente), ENT_QUOTES, 'UTF-8') ?>)" class="text-cyan-500 hover:text-cyan-400" title="Copiar dados do cliente">
  <i class="ph ph-clipboard-text"></i>
</a>

            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
<!-- Modal Adicionar/Editar Cliente -->
<div id="clienteModal" class="fixed inset-0 bg-black bg-opacity-50 hidden flex items-center justify-center z-50">
  <div class="bg-white dark:bg-gray-800 p-6 rounded-lg w-full max-w-md">
    <h2 class="text-lg font-semibold mb-4">Cliente</h2>
    <form method="POST">
      <input type="hidden" name="edit_id" id="edit_id">
      <input type="text" name="nome" id="nome" class="w-full mb-2 p-2 rounded border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700" placeholder="Nome" required>
      <input type="text" name="dominio" id="dominio" class="w-full mb-2 p-2 rounded border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700" placeholder="Domínio" required>
      <input type="text" name="tipo" id="tipo" class="w-full mb-2 p-2 rounded border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700" placeholder="Tipo de Plano" required>
      <input type="number" step="0.01" name="preco" id="preco" class="w-full mb-2 p-2 rounded border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700" placeholder="Preço" required>
      <input type="text" name="whatsapp" id="whatsapp" class="w-full mb-2 p-2 rounded border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700" placeholder="WhatsApp" required>
      <input type="text" name="codigo_verificacao" id="codigo_verificacao" class="w-full mb-2 p-2 rounded border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700" placeholder="Código de Verificação">
      <input type="date" name="vencimento" id="vencimento" class="w-full mb-4 p-2 rounded border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700" required>
      <div class="flex justify-end gap-2">
        <button type="button" onclick="document.getElementById('clienteModal').classList.add('hidden')" class="px-4 py-2 rounded bg-gray-300 dark:bg-gray-600 text-gray-800 dark:text-white">Cancelar</button>
        <button type="submit" class="px-4 py-2 rounded bg-blue-600 text-white">Salvar</button>
      </div>
    </form>
  </div>
</div>

<!-- Scripts -->
<script>
  const toggleBtn = document.getElementById('toggleTheme');
  const html = document.documentElement;

  // Tema inicial
  if (localStorage.getItem('modo') === 'light') {
    html.classList.remove('dark');
  } else {
    html.classList.add('dark');
  }

  // Alternar tema
  toggleBtn.addEventListener('click', () => {
    html.classList.toggle('dark');
    const modoAtual = html.classList.contains('dark') ? 'dark' : 'light';
    localStorage.setItem('modo', modoAtual);
  });
  function fecharModal() {
  const modal = document.getElementById('modalSucesso');
  if (modal) modal.style.display = 'none';
}


  // Edição
  function editarCliente(cliente) {
    document.getElementById('edit_id').value = cliente.id;
    document.getElementById('nome').value = cliente.nome;
    document.getElementById('dominio').value = cliente.dominio;
    document.getElementById('tipo').value = cliente.tipo;
    document.getElementById('preco').value = cliente.preco;
    document.getElementById('whatsapp').value = cliente.whatsapp;
    document.getElementById('codigo_verificacao').value = cliente.codigo_verificacao;
    document.getElementById('vencimento').value = cliente.vencimento;
    document.getElementById('clienteModal').classList.remove('hidden');
  }

  // Busca em tempo real
  document.getElementById('buscaCliente').addEventListener('input', function () {
    const filtro = this.value.toLowerCase();
    const linhas = document.querySelectorAll('tbody tr');
    linhas.forEach(linha => {
      const texto = linha.textContent.toLowerCase();
      linha.style.display = texto.includes(filtro) ? '' : 'none';
    });
  });

  // Toggle menu mobile
  function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    sidebar.classList.toggle('-translate-x-full');
  }
</script>
<?php if ($clienteExcluido): ?>
<div id="modalSucesso" class="fixed inset-0 bg-black/70 backdrop-blur-sm flex items-center justify-center z-50">
  <div class="bg-white dark:bg-gray-900 p-6 rounded-xl shadow-2xl text-center max-w-sm w-full border border-blue-500 dark:border-blue-700">
    <div class="text-5xl mb-3 animate-bounce">🧹</div>
    <h2 class="text-lg font-bold mb-1 text-gray-800 dark:text-white">Adeus, cliente! 👋</h2>
    <p class="text-sm text-gray-600 dark:text-gray-300">Cliente excluído com sucesso! Foi tarde 😅</p>
    <button onclick="fecharModal()" class="mt-4 px-5 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded shadow-md transition-all">OK</button>
  </div>
</div>
<?php endif; ?>

<?php if ($clienteEditado): ?>
<div id="modalSucesso" class="fixed inset-0 bg-black/70 backdrop-blur-sm flex items-center justify-center z-50">
  <div class="bg-white dark:bg-gray-900 p-6 rounded-xl shadow-2xl text-center max-w-sm w-full border border-green-500 dark:border-green-700">
    <div class="text-5xl mb-3 animate-bounce">🛠️</div>
    <h2 class="text-lg font-bold mb-1 text-gray-800 dark:text-white">Cliente atualizado! ✅</h2>
    <p class="text-sm text-gray-600 dark:text-gray-300">As alterações foram salvas com sucesso. Tudo certo agora! 😎</p>
    <button onclick="fecharModal()" class="mt-4 px-5 py-2 bg-green-600 hover:bg-green-700 text-white rounded shadow-md transition-all">OK</button>
  </div>
</div>
<?php endif; ?>

<?php if (isset($_GET['renovado'])): ?>
<?php
  $nome = $_GET['nome'] ?? '';
  $dominio = $_GET['dominio'] ?? '';
  $tipo = $_GET['tipo'] ?? '';
  $preco = $_GET['preco'] ?? '';
  $whatsapp = $_GET['whatsapp'] ?? '';
  $vencimento = $_GET['vencimento'] ?? '';
  $vencimentoFormatado = date('d/m/Y', strtotime($vencimento));

  $textoCopiar = "🎉 *Plano Renovado com Sucesso!* 🎉\n\n";
$textoCopiar .= "Olá, {$nome}! Tudo certo? 😄\n\n";
$textoCopiar .= "Passando para confirmar que sua assinatura foi *renovada com sucesso* e você já está com o acesso 100% garantido! 👇\n\n";
$textoCopiar .= "🌐 *Domínio:* {$dominio}\n";
$textoCopiar .= "📦 *Plano:* {$tipo}\n";
$textoCopiar .= "💰 *Valor:* R$ " . number_format($preco, 2, ',', '.') . "\n";
$textoCopiar .= "📲 *WhatsApp:* {$whatsapp}\n";
$textoCopiar .= "📅 *Próximo Vencimento:* {$vencimentoFormatado}\n\n";
$textoCopiar .= "⚠️ *Importante:* Para evitar qualquer tipo de bloqueio automático, recomendamos que a renovação seja feita com pelo menos *2 dias de antecedência* ao vencimento. Assim você garante acesso contínuo e sem interrupções! 🔁\n\n";
$textoCopiar .= "✅ Seu serviço está ativo e funcionando perfeitamente.\n\n";
$textoCopiar .= "🙏 *Agradecemos imensamente pela confiança!* Estamos sempre à disposição para o que precisar. Qualquer dúvida ou suporte, é só chamar! 💬\n\n";
$textoCopiar .= "🚀 *LCS FORNECEDOR - Qualidade e Suporte de Verdade!*";

?>
<div id="modalSucesso" class="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-50">
  <div class="bg-white dark:bg-gray-900 p-6 rounded-xl shadow-2xl text-center max-w-sm w-full border border-blue-500 dark:border-blue-700 relative">
    <div class="text-5xl mb-3">📅</div>
    <h2 class="text-lg font-bold mb-1 text-gray-800 dark:text-white">Renovado com sucesso! 🎉</h2>
    <p class="text-sm text-gray-600 dark:text-gray-300 mb-4">Os dados foram atualizados. Pronto para compartilhar com o cliente?</p>
    <textarea id="textoRenovado" class="w-full text-sm p-3 rounded bg-gray-100 dark:bg-gray-800 text-gray-900 dark:text-white border border-gray-300 dark:border-gray-600" rows="8" readonly><?= $textoCopiar ?></textarea>
    <div class="flex flex-col sm:flex-row justify-center gap-3 mt-4">
      <button onclick="copiarTexto()" class="px-5 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded shadow-md transition-all">📋 Copiar Dados</button>
      <button onclick="fecharModal()" class="px-5 py-2 bg-gray-300 dark:bg-gray-600 text-gray-800 dark:text-white rounded">Fechar</button>
    </div>
  </div>
</div>

<script>
  // Impede fechamento automático
  document.addEventListener('DOMContentLoaded', () => {
    const modal = document.getElementById('modalSucesso');
    modal.addEventListener('click', function(event) {
      event.stopPropagation(); // bloqueia cliques fora
    });
  });

  function copiarTexto() {
  const textarea = document.getElementById('textoRenovado');
  textarea.select();
  document.execCommand('copy');

  Swal.fire({
    icon: 'success',
    title: 'Copiado!',
    text: 'Dados copiados com sucesso.',
    timer: 1500,
    showConfirmButton: false
  });
}


  function fecharModal() {
    const modal = document.getElementById('modalSucesso');
    if (modal) modal.remove();
  }
  
</script>
<?php endif; ?>

<script>
  function copiarInfoCliente(cliente) {
    const venc = new Date(cliente.vencimento).toLocaleDateString('pt-BR');
    const texto = `📋 *SEUS DADOS DE ACESSO* 📋

Olá, *${cliente.nome}*! Seja bem-vindo(a) novamente! 😄

Aqui estão os seus dados atualizados para garantir acesso total ao seu serviço: 👇

🌐 *Domínio:* ${cliente.dominio}  
📦 *Plano:* ${cliente.tipo}  
💰 *Valor:* R$ ${parseFloat(cliente.preco).toFixed(2).replace('.', ',')}  
📲 *WhatsApp:* ${cliente.whatsapp}  
📅 *Vencimento:* ${venc}

⚠️ *Dica Importante:* Recomendamos renovar com pelo menos *2 dias de antecedência* para evitar bloqueio automático e manter seu acesso garantido! 🔁

🚀 Qualquer dúvida ou ajuda, é só chamar no WhatsApp. Estamos sempre por aqui! 💬

✨ *LCS FORNECEDOR - Conectando você com qualidade, suporte e confiança!*`;

    navigator.clipboard.writeText(texto).then(() => {
      const aviso = document.createElement('div');
      aviso.textContent = '📋 Dados copiados com sucesso!';
      aviso.className = 'fixed bottom-4 left-1/2 -translate-x-1/2 bg-green-600 text-white px-4 py-2 rounded-lg shadow-lg z-50 backdrop-blur-sm';
      document.body.appendChild(aviso);
      setTimeout(() => aviso.remove(), 3000);
    }).catch(() => {
      alert('Erro ao copiar os dados.');
    });
  }
</script>
